//+------------------------------------------------------------------+
//|                                                 QQE Alert v3.mq4 |
//|                                                    Skyline, 2007 |
//|                                             www.forexpertutti.it |
//+------------------------------------------------------------------+
#property copyright "Skyline, 2007"
#property link      "www.forexpertutti.it"

#property indicator_chart_window

#property indicator_buffers 3
#property indicator_color1 DeepSkyBlue
#property indicator_color2 Orange
#property indicator_color3 Gray
extern string Comment1             = "QQEA Alert v3 compiled by Skyline on 31 Oct 2007";
extern string Comment2             = "modded by trendchaser";
extern string Comment3             = "email : glicci@yahoo.it"; 
//extern bool   ShowCrossQQE_RSISlow = true;
extern int    DOT_Width            = 0;
extern int    buy_sl_distance               = 9;
extern int    sell_sl_distance               = -9;
extern int    anaconda               = 9;
extern int    QQE_SF               = 1;
extern int    QQE_RSI_Period       = 14;
extern double QQE_DARFACTOR        = 3.5; 

double QQE_Position         = 1;
 
extern bool   EnableSoundAlert     = true;
bool   EnableVisualAlert    = false;
bool   EnableEmailAlert     = false;
 
extern int DMI_Smooth   = 14;
extern bool DMI_Hide_DI_Plus  = False;
extern bool DMI_Hide_DI_Minus = False;
extern bool DMI_Hide_DX   = true;
extern bool DMI_Hide_ADX  = true;
extern bool DMI_Hide_ADXR = true;

extern int MomPeriod=10;
extern color    color_up = DeepSkyBlue;
extern color    color_dn = Orange;
extern color    color_none = Gray;
bool sound_long=true;
bool sound_short=true;

double CrossUp[];
double CrossDown[];
double none[];
static datetime alertTag = D'1980.01.01'; 
static datetime soundTag = D'1980.01.01';
static datetime emailTag = D'1980.01.01';

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
    SetIndexStyle(0, DRAW_ARROW, EMPTY,DOT_Width, color_up);
    SetIndexArrow(0, 233);
    SetIndexBuffer(0, CrossUp);
    SetIndexStyle(1, DRAW_ARROW, EMPTY,DOT_Width, color_dn);
    SetIndexArrow(1, 234);
    SetIndexBuffer(1, CrossDown);   
    SetIndexStyle(2, DRAW_ARROW, EMPTY,DOT_Width, color_none);
    SetIndexArrow(2, 251);
    SetIndexBuffer(2, none); 
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//---- 

//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start() 
{
   int limit, i, counter;
   //double fasterEMAnow, slowerEMAnow, fasterEMAprevious, slowerEMAprevious, fasterEMAafter, slowerEMAafter;
   double fasterRSInow,slowerRSInow,fasterRSIprevious,slowerRSIprevious,fasterRSIafter,slowerRSIafter;
   double Range, AvgRange;
   
   int counted_bars=IndicatorCounted();
//---- check for possible errors

   if(counted_bars<0) return(-1);
   
//---- last counted bar will be recounted
   if(counted_bars>0) counted_bars--;

   limit=Bars-counted_bars;
   
   for(i = 0; i <= limit; i++) 
   {
   
      counter=i;
      Range=0;
      AvgRange=0;
      for (counter=i ;counter<=i+9;counter++)
      {
         AvgRange=AvgRange+MathAbs(High[counter]-Low[counter]);
      }
      Range=AvgRange/10;
       double lo=iLow(Symbol(),0,i);
       double hi=iHigh(Symbol(),0,i);
      double cl=iClose(Symbol(),0,i);
     double ma= iMA(NULL,0,anaconda,1,MODE_SMA,PRICE_CLOSE,i);
   double mom=iCustom(Symbol(),0,"MomentumVT",MomPeriod,0,i);
  
   
   double dmi_1=iCustom(Symbol(),0,"dmi",DMI_Smooth,DMI_Hide_DI_Plus,DMI_Hide_DI_Minus,DMI_Hide_DX,DMI_Hide_ADX,DMI_Hide_ADXR,0,i);

   double dmi_2=iCustom(Symbol(),0,"dmi",DMI_Smooth,DMI_Hide_DI_Plus,DMI_Hide_DI_Minus,DMI_Hide_DX,DMI_Hide_ADX,DMI_Hide_ADXR,1,i);

   
   
      fasterRSInow      = iCustom(NULL,0,"QQEA",QQE_SF,QQE_RSI_Period,QQE_DARFACTOR,0,i);
      fasterRSIprevious = iCustom(NULL,0,"QQEA",QQE_SF,QQE_RSI_Period,QQE_DARFACTOR,0,i+1); 
      fasterRSIafter    = iCustom(NULL,0,"QQEA",QQE_SF,QQE_RSI_Period,QQE_DARFACTOR,0,i-1); 

      slowerRSInow      = iCustom(NULL,0,"QQEA",QQE_SF,QQE_RSI_Period,QQE_DARFACTOR,1,i);
      slowerRSIprevious = iCustom(NULL,0,"QQEA",QQE_SF,QQE_RSI_Period,QQE_DARFACTOR,1,i+1); 
      slowerRSIafter    = iCustom(NULL,0,"QQEA",QQE_SF,QQE_RSI_Period,QQE_DARFACTOR,1,i-1); 

if(cl<ma)sound_long=true;
if(cl>ma)sound_short=true;

if(dmi_1<20)sound_long=true;
if(dmi_2<20)sound_short=true;

if(mom<0)sound_long=true;
if(mom>0)sound_short=true;

if(fasterRSInow < slowerRSInow)sound_long=true;
if(fasterRSInow > slowerRSInow)sound_short=true;

      if ((lo>ma+buy_sl_distance*Point)&&(dmi_1>dmi_2)&&(cl>ma+buy_sl_distance*Point)&&(dmi_1>20)&&(mom>0)&&(fasterRSInow > slowerRSInow) ) 
      
         CrossUp[i] = ma+buy_sl_distance*Point;
       
      if ((hi<ma+sell_sl_distance*Point)&&(dmi_1<dmi_2)&&(cl<ma+sell_sl_distance*Point)&&(dmi_2>20)&&(mom<0)&&(fasterRSInow < slowerRSInow) ) 
      
          CrossDown[i] = ma+sell_sl_distance*Point ;
      if (CrossDown[i]!= ma+sell_sl_distance*Point && CrossUp[i] != ma+buy_sl_distance*Point )none[i] = ma ;
      /*  if (SoundON==true && i==1 && CrossUp[i] > CrossDown[i] && alertTag!=Time[0])
        {
         Alert("EMA Cross Trend going Down on ",Symbol()," ",Period());
         alertTag = Time[0];
        }
        if (SoundON==true && i==1 && CrossUp[i] < CrossDown[i] && alertTag!=Time[0])
        {
         Alert("EMA Cross Trend going Up on ",Symbol()," ",Period());
         alertTag = Time[0];
        } */
        
        // Gestione Alert visivo //
        if (EnableVisualAlert==true && i==1 && CrossUp[i] > CrossDown[i] && alertTag!=Time[0])
        {
         Alert("QQE Cross Trend going DOWN on ",Symbol()," ",Periodo(Period()));
         alertTag = Time[0];
        }
        if (EnableVisualAlert==true && i==1 && CrossUp[i] < CrossDown[i] && alertTag!=Time[0])
        {
         Alert("QQE Cross Trend going UP on ",Symbol()," ",Periodo(Period()));
         alertTag = Time[0];
        }   
          
        // Gestione Alert sonoro //      
        if (sound_long&&EnableSoundAlert==true && i==1 && CrossUp[i] > CrossDown[i] && soundTag!=Time[0])
        {
         PlaySound ("short.wav");
         soundTag = Time[0];
         sound_long=false;
         sound_short=true;
        }
        if (sound_short&&EnableSoundAlert==true && i==1 && CrossUp[i] < CrossDown[i] && soundTag!=Time[0])
        {
         PlaySound ("long.wav");
         soundTag = Time[0];
         sound_long=true;
         sound_short=false;
        } 
        
        // Gestione Alert con email //      
        if (EnableEmailAlert==true && i==1 && CrossUp[i] > CrossDown[i] && emailTag!=Time[0])
        {
         SendMail("Supernova alert signal!","QQE Cross Trend going DONWN on " + (StringConcatenate(Symbol()," ",Periodo(Period()))));
         emailTag = Time[0];
        }
        if (EnableEmailAlert==true && i==1 && CrossUp[i] < CrossDown[i] && emailTag!=Time[0])
        {
         SendMail("Supernova alert signal!","QQE Cross Trend going UP on " + (StringConcatenate(Symbol()," ",Periodo(Period()))));
         emailTag = Time[0];
        } 
  }
   return(0);
}

string Periodo(int TF)
{
 if (TF==1)    { return("M1"); }
 if (TF==5)    { return("M5"); }
 if (TF==15)   { return("M15"); }
 if (TF==30)   { return("M30"); } 
 if (TF==60)   { return("H1"); } 
 if (TF==240)  { return("H4"); } 
 if (TF==1440) { return("D1"); }  
}

